/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.fcs.impl.udp;

import com.ibm.hwmca.fw.fcs.impl.udp.FcsDatagram;
import com.ibm.hwmca.fw.fcs.impl.udp.NotificationQueue;
import com.ibm.hwmca.fw.util.Trace;
import java.net.DatagramPacket;
import java.net.DatagramSocket;

public class DatagramSocketListener
extends Thread {
    private static final String TRACE_MASKD = "XFCSDSLD";
    private static final String TRACE_MASKF = "XFCSDSLF";
    private static final String TRACE_MASKT = "XFCSDSLT";
    private DatagramSocket socket;
    private NotificationQueue datagramQueue;

    public DatagramSocketListener(DatagramSocket socket, NotificationQueue datagramQueue) {
        Trace.trace(TRACE_MASKF, "<> DatagramSocketListener");
        this.socket = socket;
        this.datagramQueue = datagramQueue;
    }

    public void closeSocket() {
        Trace.trace(TRACE_MASKF, "<> closeSocket()");
        try {
            this.socket.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.socket = null;
        }
        catch (Exception e) {}
    }

    public void run() {
        try {
            this.setName("FCS Datagram socket listener on: " + this.socket.getInetAddress().toString());
        }
        catch (Exception e) {}
        while (this.socket != null) {
            byte[] buffer = new byte[504];
            DatagramPacket inPacket = new DatagramPacket(buffer, buffer.length);
            try {
                this.socket.receive(inPacket);
                FcsDatagram datagram = new FcsDatagram(inPacket);
                this.datagramQueue.addItem(inPacket);
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKF, e);
            }
        }
    }
}

